* International Extension - What Caused the U.S Pandemic-Era Inflation? Bernanke, Blanchard 2023 
* This version : April 16, 2024
* Please contact Dilek Sevinc (dsevinc@piie.com) for further questions. 

global basePath1 ".../Replication Package/(1) Data"
global basePath2 ".../Replication Package/(3) Regression Results"

********************************************************************************
** All four equations for Germany 											  **
********************************************************************************

drop _all
clear matrix
clear mata   	
set more off	

cd "$basePath1"
use interm_all_clear, clear
cd "$basePath2"

local time1 "tin(1996q1,2019q4)"
local time2 "tin(1996q1,2023q2)"

forval t=1/2{

constraint define 1  [gw_GER]l1.gw_GER + [gw_GER]l2.gw_GER + [gw_GER]l3.gw_GER + [gw_GER]l4.gw_GER + [gw_GER]l1.cf1_GER + [gw_GER]l2.cf1_GER + [gw_GER]l3.cf1_GER + [gw_GER]l4.cf1_GER = 1

constraint define 2  [gcpi_GER]l1.gcpi_GER + [gcpi_GER]l2.gcpi_GER + [gcpi_GER]l3.gcpi_GER + [gcpi_GER]l4.gcpi_GER + [gcpi_GER]gw_GER + [gcpi_GER]l1.gw_GER + [gcpi_GER]l2.gw_GER + [gcpi_GER]l3.gw_GER + [gcpi_GER]l4.gw_GER = 1

constraint define 3  [cf1_GER]l1.cf1_GER + [cf1_GER]l2.cf1_GER + [cf1_GER]l3.cf1_GER + [cf1_GER]l4.cf1_GER + [cf1_GER]cf10_GER + [cf1_GER]l1.cf10_GER + [cf1_GER]l2.cf10_GER + [cf1_GER]l3.cf10_GER + [cf1_GER]l4.cf10_GER + [cf1_GER]gcpi_GER + [cf1_GER]l1.gcpi_GER + [cf1_GER]l2.gcpi_GER + [cf1_GER]l3.gcpi_GER + [cf1_GER]l4.gcpi_GER = 1.0

constraint define 4  [cf10_GER]l1.cf10_GER + [cf10_GER]l2.cf10_GER + [cf10_GER]l3.cf10_GER + [cf10_GER]l4.cf10_GER + [cf10_GER]gcpi_GER + [cf10_GER]l1.gcpi_GER + [cf10_GER]l2.gcpi_GER + [cf10_GER]l3.gcpi_GER + [cf10_GER]l4.gcpi_GER = 1.0

reg3 (gw_GER l1.gw_GER l2.gw_GER l3.gw_GER l4.gw_GER l1.cf1_GER l2.cf1_GER l3.cf1_GER l4.cf1_GER l1.magpty_GER l1.vu_GER l2.vu_GER l3.vu_GER l4.vu_GER l1.diffcpicf_GER l2.diffcpicf_GER l3.diffcpicf_GER l4.diffcpicf_GER dummyq2_2020 dummyq3_2020) (gcpi_GER magpty_GER l1.gcpi_GER l2.gcpi_GER l3.gcpi_GER l4.gcpi_GER gw_GER l1.gw_GER l2.gw_GER l3.gw_GER l4.gw_GER grpe_GER l1.grpe_GER l2.grpe_GER l3.grpe_GER l4.grpe_GER grpf_GER l1.grpf_GER l2.grpf_GER l3.grpf_GER l4.grpf_GER shortage_GER l1.shortage_GER l2.shortage_GER l3.shortage_GER l4.shortage_GER) (cf1_GER l1.cf1_GER l2.cf1_GER l3.cf1_GER l4.cf1_GER cf10_GER l1.cf10_GER l2.cf10_GER l3.cf10_GER l4.cf10_GER gcpi_GER l1.gcpi_GER l2.gcpi_GER l3.gcpi_GER l4.gcpi_GER, noconstant) (cf10_GER l1.cf10_GER l2.cf10_GER l3.cf10_GER l4.cf10_GER gcpi_GER l1.gcpi_GER l2.gcpi_GER l3.gcpi_GER l4.gcpi_GER , noconstant) if `time`t'', c(1 2 3 4) endog(gw_GER gcpi_GER cf1_GER cf10_GER diffcpicf_GER grpe_GER grpf_GER) exog(magpty_GER vu_GER shortage_GER) ols dfk

			
estimates store m1			


*compute residuals and fitted values;
qui predict e_gw_GER_`t'	,equation(gw_GER)   residuals
qui predict e_gcpi_GER_`t'	,equation(gcpi_GER) residuals
qui predict e_cf1_GER_`t'	,equation(cf1_GER)  residuals
qui predict e_cf10_GER_`t'	,equation(cf10_GER) residuals
			
qui predict fit_gw_GER_`t'	 ,equation(gw_GER)   xb
qui predict fit_gcpi_GER_`t' ,equation(gcpi_GER) xb
qui predict fit_cf1_GER_`t'  ,equation(cf1_GER)  xb
qui predict fit_cf10_GER_`t' ,equation(cf10_GER) xb




*** WAGE EQUATION  
			
* Save coefficients in excel format 
putexcel set "(1) wage_eq_coeff", modify sheet("gw_GER`t'")
putexcel B1 = "beta_precovid"
putexcel B1 = "beta_precovid"
matrix b = e(b)'
putexcel A2 = matrix(b), rownames nformat(number_d7)


* Save summary stats in excel format 
putexcel set "(1) wage_summary_stats", modify sheet("gw_GER`t'")
putexcel B1 = "sum of coefficients_precovid"
putexcel B1 = "sum of coefficients_precovid"
putexcel C1 = "p value (sum)_precovid"
putexcel D1 = "p value (joint)_precovid"
putexcel A2 = "l1.gw through l4.gw"
putexcel A3 = "l1.cf1 through l4.cf1"
putexcel A4 = "l1.vu through l4.vu"
putexcel A5 = "l1.diffcpicf through l4.diffcpicf"
putexcel A6 = "magpty"
putexcel A7 = "dummy 2020Q2"
putexcel A8 = "dummy 2020Q3"
putexcel A10 = "R2"
putexcel A11 = "number of observations"
putexcel A13 = "homogeneity constraint"

* Compute sum of coefficients 

gen aa`t' = [gw_GER]_b[l1.gw_GER]	+[gw_GER]_b[l2.gw_GER]	+[gw_GER]_b[l3.gw_GER]	+[gw_GER]_b[l4.gw_GER]
gen ab`t' = [gw_GER]_b[l1.cf1_GER]	+[gw_GER]_b[l2.cf1_GER]	+[gw_GER]_b[l3.cf1_GER]	+[gw_GER]_b[l4.cf1_GER]
gen ac`t' = [gw_GER]_b[l1.vu_GER]	+[gw_GER]_b[l2.vu_GER]	+[gw_GER]_b[l3.vu_GER]	+[gw_GER]_b[l4.vu_GER]
gen ad`t' = [gw_GER]_b[l1.diffcpicf_GER]+[gw_GER]_b[l2.diffcpicf_GER]+[gw_GER]_b[l3.diffcpicf_GER]+[gw_GER]_b[l4.diffcpicf_GER]
gen ae`t' = [gw_GER]_b[l1.magpty_GER]
gen af`t' = [gw_GER]_b[dummyq2_2020]
gen ag`t' = [gw_GER]_b[dummyq3_2020]


putexcel B2 = aa`t'
putexcel B3 = ab`t'
putexcel B4 = ac`t'
putexcel B5 = ad`t'
putexcel B6 = ae`t' 
putexcel B7 = af`t'
putexcel B8 = ag`t'

* P-value (sum)

test [gw_GER]_b[l1.gw_GER]	+[gw_GER]_b[l2.gw_GER]	+[gw_GER]_b[l3.gw_GER]	+[gw_GER]_b[l4.gw_GER] = 0
matrix b = r(p)'
putexcel C2 = matrix(b), nformat(number_d7)                                          

test [gw_GER]_b[l1.cf1_GER]	+[gw_GER]_b[l2.cf1_GER]	+[gw_GER]_b[l3.cf1_GER]	+[gw_GER]_b[l4.cf1_GER] = 0
matrix b = r(p)'
putexcel C3 = matrix(b), nformat(number_d7)

test [gw_GER]_b[l1.vu_GER]	+[gw_GER]_b[l2.vu_GER]	+[gw_GER]_b[l3.vu_GER]	+[gw_GER]_b[l4.vu_GER] = 0
matrix b = r(p)'
putexcel C4 = matrix(b), nformat(number_d7)  

test [gw_GER]_b[l1.diffcpicf_GER]+[gw_GER]_b[l2.diffcpicf_GER]+[gw_GER]_b[l3.diffcpicf_GER]+[gw_GER]_b[l4.diffcpicf_GER] = 0
matrix b = r(p)'
putexcel C5 = matrix(b), nformat(number_d7) 


* P-value(joint)
test [gw_GER]_b[l1.gw_GER] [gw_GER]_b[l2.gw_GER] [gw_GER]_b[l3.gw_GER] [gw_GER]_b[l4.gw_GER]
matrix b = r(p)'
putexcel D2 = matrix(b), nformat(number_d7)  
   
test [gw_GER]_b[l1.cf1_GER]	[gw_GER]_b[l2.cf1_GER] [gw_GER]_b[l3.cf1_GER] [gw_GER]_b[l4.cf1_GER]
matrix b = r(p)'
putexcel D3 = matrix(b), nformat(number_d7) 
   
test [gw_GER]_b[l1.vu_GER] [gw_GER]_b[l2.vu_GER] [gw_GER]_b[l3.vu_GER] [gw_GER]_b[l4.vu_GER] 
matrix b = r(p)'
putexcel D4 = matrix(b), nformat(number_d7)    

test [gw_GER]_b[l1.diffcpicf_GER] [gw_GER]_b[l2.diffcpicf_GER] [gw_GER]_b[l3.diffcpicf_GER] [gw_GER]_b[l4.diffcpicf_GER]
matrix b = r(p)'
putexcel D5 = matrix(b), nformat(number_d7)    

test [gw_GER]_b[l1.magpty_GER]
matrix b = r(p)'
putexcel D6 = matrix(b), nformat(number_d7)

test [gw_GER]_b[dummyq2_2020]
matrix b = r(p)'
putexcel D7 = matrix(b), nformat(number_d7)

test [gw_GER]_b[dummyq3_2020]
matrix b = r(p)'
putexcel D8 = matrix(b), nformat(number_d7)


* R-square 
corr fit_gw_GER_`t' gw_GER if `time`t''
gen r2aa_gw_GER_`t' = r(rho)^2
putexcel B10 = r2aa_gw_GER_`t'



*** PRICE EQUATION  

* Save coefficients in excel format 
putexcel set "(2) price_eq_coeff", modify sheet("gcpi_GER`t'")
putexcel B1 = "beta_precovid"
putexcel B1 = "beta_precovid"
matrix b = e(b)'
putexcel A2 = matrix(b), rownames nformat(number_d7)


* Save summary stats in excel format 
putexcel set "(2) price_summary_stats", modify sheet("gcpi_GER`t'")
putexcel B1 = "sum of coefficients_precovid"
putexcel B1 = "sum of coefficients_precovid"
putexcel C1 = "p value (sum)_precovid"
putexcel D1 = "p value (joint)_precovid"
putexcel A2 = "l1.gcpi through l4.gcpi"
putexcel A3 = "gw through l4.gw" 
putexcel A4 = "grpe through l4.grpe"
putexcel A5 = "grpf through l4.grpf"
putexcel A6 = "shortage through l4.shortage"
putexcel A7 = "magpty"
putexcel A9 = "R2"
putexcel A10 = "number of observations"
putexcel A12 = "homogeneity constraint"


* Compute sum of coefficients 
gen ba`t' = [gcpi_GER]_b[l1.gcpi_GER]+[gcpi_GER]_b[l2.gcpi_GER]+[gcpi_GER]_b[l3.gcpi_GER]+[gcpi_GER]_b[l4.gcpi_GER]
gen bb`t' = [gcpi_GER]_b[gw_GER]+[gcpi_GER]_b[l1.gw_GER]+[gcpi_GER]_b[l2.gw_GER]+[gcpi_GER]_b[l3.gw_GER]+[gcpi_GER]_b[l4.gw_GER]
gen bc`t' = [gcpi_GER]_b[grpe_GER]+[gcpi_GER]_b[l1.grpe_GER]+[gcpi_GER]_b[l2.grpe_GER]+[gcpi_GER]_b[l3.grpe_GER]+[gcpi_GER]_b[l4.grpe_GER]
gen bd`t' = [gcpi_GER]_b[grpf_GER]+[gcpi_GER]_b[l1.grpf_GER]+[gcpi_GER]_b[l2.grpf_GER]+[gcpi_GER]_b[l3.grpf_GER]+[gcpi_GER]_b[l4.grpf_GER]
gen be`t' = [gcpi_GER]_b[shortage_GER]+[gcpi_GER]_b[l1.shortage_GER]+[gcpi_GER]_b[l2.shortage_GER]+[gcpi_GER]_b[l3.shortage_GER]+[gcpi_GER]_b[l4.shortage_GER]
gen bf`t' = [gcpi_GER]_b[magpty_GER]


putexcel B2 = ba`t'
putexcel B3 = bb`t'
putexcel B4 = bc`t'
putexcel B5 = bd`t'
putexcel B6 = be`t'
putexcel B7 = bf`t'


* P-value (sum)
test [gcpi_GER]_b[l1.gcpi_GER]+[gcpi_GER]_b[l2.gcpi_GER]+[gcpi_GER]_b[l3.gcpi_GER]+[gcpi_GER]_b[l4.gcpi_GER] = 0
matrix b = r(p)'
putexcel C2 = matrix(b), nformat(number_d7)

test [gcpi_GER]_b[gw_GER]+[gcpi_GER]_b[l1.gw_GER]+[gcpi_GER]_b[l2.gw_GER]+[gcpi_GER]_b[l3.gw_GER]+[gcpi_GER]_b[l4.gw_GER] = 0 
matrix b = r(p)'
putexcel C3 = matrix(b), nformat(number_d7) 

test [gcpi_GER]_b[grpe_GER]+[gcpi_GER]_b[l1.grpe_GER]+[gcpi_GER]_b[l2.grpe_GER]+[gcpi_GER]_b[l3.grpe_GER]+[gcpi_GER]_b[l4.grpe_GER] = 0
matrix b = r(p)'
putexcel C4 = matrix(b), nformat(number_d7)

test [gcpi_GER]_b[grpf_GER]+[gcpi_GER]_b[l1.grpf_GER]+[gcpi_GER]_b[l2.grpf_GER]+[gcpi_GER]_b[l3.grpf_GER]+[gcpi_GER]_b[l4.grpf_GER] = 0
matrix b = r(p)'
putexcel C5 = matrix(b), nformat(number_d7)

test [gcpi_GER]_b[shortage_GER]+[gcpi_GER]_b[l1.shortage_GER]+[gcpi_GER]_b[l2.shortage_GER]+[gcpi_GER]_b[l3.shortage_GER]+[gcpi_GER]_b[l4.shortage_GER] = 0 
matrix b = r(p)'
putexcel C6 = matrix(b), nformat(number_d7)

	   					   
* P-value(joint)
test [gcpi_GER]_b[l1.gcpi_GER] [gcpi_GER]_b[l2.gcpi_GER] [gcpi_GER]_b[l3.gcpi_GER] [gcpi_GER]_b[l4.gcpi_GER]
matrix b = r(p)'
putexcel D2 = matrix(b), nformat(number_d7)  
   
test [gcpi_GER]_b[gw_GER] [gcpi_GER]_b[l1.gw_GER] [gcpi_GER]_b[l2.gw_GER] [gcpi_GER]_b[l3.gw_GER] [gcpi_GER]_b[l4.gw_GER]
matrix b = r(p)'
putexcel D3 = matrix(b), nformat(number_d7) 
   
test [gcpi_GER]_b[grpe_GER] [gcpi_GER]_b[l1.grpe_GER] [gcpi_GER]_b[l2.grpe_GER] [gcpi_GER]_b[l3.grpe_GER] [gcpi_GER]_b[l4.grpe_GER]
matrix b = r(p)'
putexcel D4 = matrix(b), nformat(number_d7)    

test [gcpi_GER]_b[grpf_GER] [gcpi_GER]_b[l1.grpf_GER] [gcpi_GER]_b[l2.grpf_GER] [gcpi_GER]_b[l3.grpf_GER] [gcpi_GER]_b[l4.grpf_GER]
matrix b = r(p)'
putexcel D5 = matrix(b), nformat(number_d7)    

test [gcpi_GER]_b[shortage_GER] [gcpi_GER]_b[l1.shortage_GER] [gcpi_GER]_b[l2.shortage_GER] [gcpi_GER]_b[l3.shortage_GER] [gcpi_GER]_b[l4.shortage_GER]
matrix b = r(p)'
putexcel D6 = matrix(b), nformat(number_d7)

test [gcpi_GER]_b[magpty_GER]
matrix b = r(p)'
putexcel D7 = matrix(b), nformat(number_d7)


* R-square 
corr fit_gcpi_GER_`t' gcpi_GER if period>=tq(1990:1)
gen r2aa_gcpi_GER_`t' = r(rho)^2
putexcel B9 = r2aa_gcpi_GER_`t'




*** SHORT-TERM EXPECTATIONS

* Save coefficients in excel format 
putexcel set "(3) cf1_eq_coeff", modify sheet("cf1_GER`t'")
putexcel B1 = "beta_precovid"
putexcel B1 = "beta_precovid"
matrix b = e(b)'
putexcel A2 = matrix(b), rownames nformat(number_d7)


* Save summary stats in excel format 
putexcel set "(3) cf1_summary_stats", modify sheet("cf1_GER`t'")
putexcel B1 = "sum of coefficients_precovid"
putexcel B1 = "sum of coefficients_precovid"
putexcel C1 = "p value (sum)_precovid"
putexcel D1 = "p value (joint)_precovid"
putexcel A2 = "l1.cf1 through l4.cf1"
putexcel A3 = "cf10 through l4.cf10" 
putexcel A4 = "gcpi through l4.gcpi"
putexcel A6 = "R2"
putexcel A7 = "number of observations"
putexcel A9 = "homogeneity constraint"

* Compute sum of coefficients 
gen ca`t' = [cf1_GER]_b[l1.cf1_GER] + [cf1_GER]_b[l2.cf1_GER] + [cf1_GER]_b[l3.cf1_GER] + [cf1_GER]_b[l4.cf1_GER]
gen cb`t' = [cf1_GER]_b[cf10_GER] + [cf1_GER]_b[l1.cf10_GER] + [cf1_GER]_b[l2.cf10_GER] + [cf1_GER]_b[l3.cf10_GER] + [cf1_GER]_b[l4.cf10_GER]
gen cc`t' = [cf1_GER]_b[gcpi_GER] + [cf1_GER]_b[l1.gcpi_GER] + [cf1_GER]_b[l2.gcpi_GER] + [cf1_GER]_b[l3.gcpi_GER] + [cf1_GER]_b[l4.gcpi_GER]

putexcel B2 = ca`t'
putexcel B3 = cb`t'
putexcel B4 = cc`t'


* P-value (sum)
test [cf1_GER]_b[l1.cf1_GER] + [cf1_GER]_b[l2.cf1_GER] + [cf1_GER]_b[l3.cf1_GER] + [cf1_GER]_b[l4.cf1_GER] = 0
matrix b = r(p)'
putexcel C2 = matrix(b), nformat(number_d7)

test [cf1_GER]_b[cf10_GER] + [cf1_GER]_b[l1.cf10_GER] + [cf1_GER]_b[l2.cf10_GER] + [cf1_GER]_b[l3.cf10_GER] + [cf1_GER]_b[l4.cf10_GER] = 0 
matrix b = r(p)'
putexcel C3 = matrix(b), nformat(number_d7) 

test [cf1_GER]_b[gcpi_GER] + [cf1_GER]_b[l1.gcpi_GER] + [cf1_GER]_b[l2.gcpi_GER] + [cf1_GER]_b[l3.gcpi_GER] + [cf1_GER]_b[l4.gcpi_GER]  = 0
matrix b = r(p)'
putexcel C4 = matrix(b), nformat(number_d7)

	   					   
* P-value(joint)
test [cf1_GER]_b[l1.cf1_GER] [cf1_GER]_b[l2.cf1_GER] [cf1_GER]_b[l3.cf1_GER] [cf1_GER]_b[l4.cf1_GER]
matrix b = r(p)'
putexcel D2 = matrix(b), nformat(number_d7)  

test [cf1_GER]_b[cf10_GER] [cf1_GER]_b[l1.cf10_GER] [cf1_GER]_b[l2.cf10_GER] [cf1_GER]_b[l3.cf10_GER] [cf1_GER]_b[l4.cf10_GER]
matrix b = r(p)'
putexcel D3 = matrix(b), nformat(number_d7) 
   
test [cf1_GER]_b[gcpi_GER] [cf1_GER]_b[l1.gcpi_GER] [cf1_GER]_b[l2.gcpi_GER] [cf1_GER]_b[l3.gcpi_GER] [cf1_GER]_b[l4.gcpi_GER]
matrix b = r(p)'
putexcel D4 = matrix(b), nformat(number_d7)    


* R-square and number of observations
corr fit_cf1_GER_`t' cf1_GER if `time`t''
gen r2cc_cf1_GER_`t' = r(rho)^2
putexcel B6 = r2cc_cf1_GER_`t'




*** LONG-TERM EXPECTATIONS

* Save coefficients in excel format 
putexcel set "(4) cf10_eq_coeff", modify sheet("cf10_GER`t'")
putexcel B1 = "beta_precovid"
putexcel B1 = "beta_precovid"
matrix b = e(b)'
putexcel A2 = matrix(b), rownames nformat(number_d7)


* Save summary stats in excel format 
putexcel set "(4) cf10_summary_stats", modify sheet("cf10_GER`t'")
putexcel B1 = "sum of coefficients_precovid"
putexcel B1 = "sum of coefficients_precovid"
putexcel C1 = "p value (sum)_precovid"
putexcel D1 = "p value (joint)_precovid"
putexcel A2 = "l1.cf10 through l4.cf10"
putexcel A3 = "gcpi through l4.gcpi"
putexcel A5 = "R2"
putexcel A6 = "number of observations"
putexcel A8 = "homogeneity constraint"


* Compute sum of coefficients 
gen da`t' = [cf10_GER]_b[l1.cf10_GER]+[cf10_GER]_b[l2.cf10_GER]+[cf10_GER]_b[l3.cf10_GER]+[cf10_GER]_b[l4.cf10_GER]
gen db`t' = [cf10_GER]_b[gcpi_GER]+[cf10_GER]_b[l1.gcpi_GER]+[cf10_GER]_b[l2.gcpi_GER]+[cf10_GER]_b[l3.gcpi_GER]+[cf10_GER]_b[l4.gcpi_GER]

putexcel B2 = da`t'
putexcel B3 = db`t'


* P-value (sum)
test [cf10_GER]_b[l1.cf10_GER]+[cf10_GER]_b[l2.cf10_GER]+[cf10_GER]_b[l3.cf10_GER]+[cf10_GER]_b[l4.cf10_GER]=0
matrix b = r(p)'
putexcel C2 = matrix(b), nformat(number_d7) 

test [cf10_GER]_b[gcpi_GER]+[cf10_GER]_b[l1.gcpi_GER]+[cf10_GER]_b[l2.gcpi_GER]+[cf10_GER]_b[l3.gcpi_GER]+[cf10_GER]_b[l4.gcpi_GER]=0
matrix b = r(p)'
putexcel C3 = matrix(b), nformat(number_d7)

	   					   
* P-value(joint)
test [cf10_GER]_b[l1.cf10_GER] [cf10_GER]_b[l2.cf10_GER] [cf10_GER]_b[l3.cf10_GER] [cf10_GER]_b[l4.cf10_GER]
matrix b = r(p)'
putexcel D2 = matrix(b), nformat(number_d7) 
   
test [cf10_GER]_b[gcpi_GER] [cf10_GER]_b[l1.gcpi_GER] [cf10_GER]_b[l2.gcpi_GER] [cf10_GER]_b[l3.gcpi_GER] [cf10_GER]_b[l4.gcpi_GER]
matrix b = r(p)'
putexcel D3 = matrix(b), nformat(number_d7)    


* R-square and number of observations
corr fit_cf10_GER_`t' cf10_GER if `time`t''
gen r2dd_cf10_GER_`t' = r(rho)^2
putexcel B5 = r2dd_cf10_GER_`t'


}


*** HOMOGENEITY TEST

*** unconstrained regressions with homogeneity test 
reg3 (gw_GER l1.gw_GER l2.gw_GER l3.gw_GER l4.gw_GER l1.cf1_GER l2.cf1_GER l3.cf1_GER l4.cf1_GER l1.magpty_GER l1.vu_GER l2.vu_GER l3.vu_GER l4.vu_GER l1.diffcpicf_GER l2.diffcpicf_GER l3.diffcpicf_GER l4.diffcpicf_GER dummyq2_2020 dummyq3_2020) (gcpi_GER magpty_GER l1.gcpi_GER l2.gcpi_GER l3.gcpi_GER l4.gcpi_GER gw_GER l1.gw_GER l2.gw_GER l3.gw_GER l4.gw_GER grpe_GER l1.grpe_GER l2.grpe_GER l3.grpe_GER l4.grpe_GER grpf_GER l1.grpf_GER l2.grpf_GER l3.grpf_GER l4.grpf_GER shortage_GER l1.shortage_GER l2.shortage_GER l3.shortage_GER l4.shortage_GER) (cf1_GER l1.cf1_GER l2.cf1_GER l3.cf1_GER l4.cf1_GER cf10_GER l1.cf10_GER l2.cf10_GER l3.cf10_GER l4.cf10_GER gcpi_GER l1.gcpi_GER l2.gcpi_GER l3.gcpi_GER l4.gcpi_GER, noconstant) (cf10_GER l1.cf10_GER l2.cf10_GER l3.cf10_GER l4.cf10_GER gcpi_GER l1.gcpi_GER l2.gcpi_GER l3.gcpi_GER l4.gcpi_GER , noconstant) if inrange(period, tq(1996:1),tq(2019:4)), endog(gw_GER gcpi_GER cf1_GER cf10_GER diffcpicf_GER grpe_GER grpf_GER) exog(magpty_GER vu_GER shortage_GER) ols dfk


test  [gw_GER]l1.gw_GER + [gw_GER]l2.gw_GER + [gw_GER]l3.gw_GER + [gw_GER]l4.gw_GER + [gw_GER]l1.cf1_GER + [gw_GER]l2.cf1_GER + [gw_GER]l3.cf1_GER + [gw_GER]l4.cf1_GER = 1

putexcel set "(1) wage_summary_stats", modify sheet("gw_GER1")
matrix b = r(p)'
putexcel B13 = matrix(b), nformat(number_d7)    


test  [gcpi_GER]l1.gcpi_GER + [gcpi_GER]l2.gcpi_GER + [gcpi_GER]l3.gcpi_GER + [gcpi_GER]l4.gcpi_GER + [gcpi_GER]gw_GER + [gcpi_GER]l1.gw_GER + [gcpi_GER]l2.gw_GER + [gcpi_GER]l3.gw_GER + [gcpi_GER]l4.gw_GER = 1

putexcel set "(2) price_summary_stats", modify sheet("gcpi_GER1")
matrix b = r(p)'
putexcel B12 = matrix(b), nformat(number_d7)    


test [cf1_GER]l1.cf1_GER + [cf1_GER]l2.cf1_GER + [cf1_GER]l3.cf1_GER + [cf1_GER]l4.cf1_GER + [cf1_GER]cf10_GER + [cf1_GER]l1.cf10_GER + [cf1_GER]l2.cf10_GER + [cf1_GER]l3.cf10_GER + [cf1_GER]l4.cf10_GER + [cf1_GER]gcpi_GER + [cf1_GER]l1.gcpi_GER + [cf1_GER]l2.gcpi_GER + [cf1_GER]l3.gcpi_GER + [cf1_GER]l4.gcpi_GER = 1.0

putexcel set "(3) cf1_summary_stats", modify sheet("cf1_GER1")
matrix b = r(p)'
putexcel B9 = matrix(b), nformat(number_d7)    


test  [cf10_GER]l1.cf10_GER + [cf10_GER]l2.cf10_GER + [cf10_GER]l3.cf10_GER + [cf10_GER]l4.cf10_GER + [cf10_GER]gcpi_GER + [cf10_GER]l1.gcpi_GER + [cf10_GER]l2.gcpi_GER + [cf10_GER]l3.gcpi_GER + [cf10_GER]l4.gcpi_GER = 1.0

putexcel set "(4) cf10_summary_stats", modify sheet("cf10_GER1")
matrix b = r(p)'
putexcel B8 = matrix(b), nformat(number_d7)    


reg3 (gw_GER l1.gw_GER l2.gw_GER l3.gw_GER l4.gw_GER l1.cf1_GER l2.cf1_GER l3.cf1_GER l4.cf1_GER l1.magpty_GER l1.vu_GER l2.vu_GER l3.vu_GER l4.vu_GER l1.diffcpicf_GER l2.diffcpicf_GER l3.diffcpicf_GER l4.diffcpicf_GER dummyq2_2020 dummyq3_2020) (gcpi_GER magpty_GER l1.gcpi_GER l2.gcpi_GER l3.gcpi_GER l4.gcpi_GER gw_GER l1.gw_GER l2.gw_GER l3.gw_GER l4.gw_GER grpe_GER l1.grpe_GER l2.grpe_GER l3.grpe_GER l4.grpe_GER grpf_GER l1.grpf_GER l2.grpf_GER l3.grpf_GER l4.grpf_GER shortage_GER l1.shortage_GER l2.shortage_GER l3.shortage_GER l4.shortage_GER) (cf1_GER l1.cf1_GER l2.cf1_GER l3.cf1_GER l4.cf1_GER cf10_GER l1.cf10_GER l2.cf10_GER l3.cf10_GER l4.cf10_GER gcpi_GER l1.gcpi_GER l2.gcpi_GER l3.gcpi_GER l4.gcpi_GER, noconstant) (cf10_GER l1.cf10_GER l2.cf10_GER l3.cf10_GER l4.cf10_GER gcpi_GER l1.gcpi_GER l2.gcpi_GER l3.gcpi_GER l4.gcpi_GER , noconstant) if inrange(period, tq(1996:1),tq(2023:2)), endog(gw_GER gcpi_GER cf1_GER cf10_GER diffcpicf_GER grpe_GER grpf_GER) exog(magpty_GER vu_GER shortage_GER) ols dfk


test  [gw_GER]l1.gw_GER + [gw_GER]l2.gw_GER + [gw_GER]l3.gw_GER + [gw_GER]l4.gw_GER + [gw_GER]l1.cf1_GER + [gw_GER]l2.cf1_GER + [gw_GER]l3.cf1_GER + [gw_GER]l4.cf1_GER = 1

putexcel set "(1) wage_summary_stats", modify sheet("gw_GER2")
matrix b = r(p)'
putexcel B13 = matrix(b), nformat(number_d7)    


test  [gcpi_GER]l1.gcpi_GER + [gcpi_GER]l2.gcpi_GER + [gcpi_GER]l3.gcpi_GER + [gcpi_GER]l4.gcpi_GER + [gcpi_GER]gw_GER + [gcpi_GER]l1.gw_GER + [gcpi_GER]l2.gw_GER + [gcpi_GER]l3.gw_GER + [gcpi_GER]l4.gw_GER = 1

putexcel set "(2) price_summary_stats", modify sheet("gcpi_GER2")
matrix b = r(p)'
putexcel B12 = matrix(b), nformat(number_d7)    


test [cf1_GER]l1.cf1_GER + [cf1_GER]l2.cf1_GER + [cf1_GER]l3.cf1_GER + [cf1_GER]l4.cf1_GER + [cf1_GER]cf10_GER + [cf1_GER]l1.cf10_GER + [cf1_GER]l2.cf10_GER + [cf1_GER]l3.cf10_GER + [cf1_GER]l4.cf10_GER + [cf1_GER]gcpi_GER + [cf1_GER]l1.gcpi_GER + [cf1_GER]l2.gcpi_GER + [cf1_GER]l3.gcpi_GER + [cf1_GER]l4.gcpi_GER = 1.0

putexcel set "(3) cf1_summary_stats", modify sheet("cf1_GER2")
matrix b = r(p)'
putexcel B9 = matrix(b), nformat(number_d7)    


test  [cf10_GER]l1.cf10_GER + [cf10_GER]l2.cf10_GER + [cf10_GER]l3.cf10_GER + [cf10_GER]l4.cf10_GER + [cf10_GER]gcpi_GER + [cf10_GER]l1.gcpi_GER + [cf10_GER]l2.gcpi_GER + [cf10_GER]l3.gcpi_GER + [cf10_GER]l4.gcpi_GER = 1.0

putexcel set "(4) cf10_summary_stats", modify sheet("cf10_GER2")
matrix b = r(p)'
putexcel B8 = matrix(b), nformat(number_d7)    





